<?php
/**
 * Setup Script untuk SumberAI
 * Jalankan script ini sekali untuk setup awal
 */

// Generate password hash untuk admin
$admin_password = 'admin123';
$hashed_password = password_hash($admin_password, PASSWORD_DEFAULT);

echo "=== SumberAI Setup ===\n\n";
echo "Password hash untuk admin (password: admin123):\n";
echo $hashed_password . "\n\n";
echo "Copy hash di atas dan paste ke database.sql pada bagian INSERT users\n";
echo "atau jalankan query berikut di database:\n\n";
echo "UPDATE users SET password = '" . $hashed_password . "' WHERE username = 'admin';\n\n";

// Test database connection
require_once 'config/database.php';

try {
    $db = Database::getInstance()->getConnection();
    echo "✓ Database connection: OK\n";
    
    // Check tables
    $tables = ['users', 'desa', 'dusun', 'prediksi_kekeringan', 'laporan_warga', 'distribusi_tangki'];
    foreach ($tables as $table) {
        $stmt = $db->query("SHOW TABLES LIKE '$table'");
        if ($stmt->rowCount() > 0) {
            echo "✓ Table '$table': OK\n";
        } else {
            echo "✗ Table '$table': MISSING\n";
        }
    }
    
    echo "\n=== Setup Complete ===\n";
    echo "Silakan hapus file setup.php setelah selesai untuk keamanan.\n";
    
} catch (Exception $e) {
    echo "✗ Error: " . $e->getMessage() . "\n";
    echo "\nPastikan:\n";
    echo "1. Database sudah dibuat\n";
    echo "2. File database.sql sudah di-import\n";
    echo "3. Konfigurasi di config/database.php sudah benar\n";
}

