<?php
require_once '../config/config.php';

if (!isAdmin()) {
    redirect('../dashboard.php');
}

$db = Database::getInstance()->getConnection();

// Get all dusun
$stmt = $db->query("SELECT * FROM dusun");
$dusun_list = $stmt->fetchAll();

$generated = 0;
$errors = 0;

foreach ($dusun_list as $dusun) {
    // Get recent rainfall data (last 30 days)
    $stmt = $db->prepare("SELECT AVG(curah_hujan) as avg_rain, COUNT(*) as count 
                          FROM data_curah_hujan 
                          WHERE dusun_id = ? AND tanggal >= DATE_SUB(CURDATE(), INTERVAL 30 DAY)");
    $stmt->execute([$dusun['id']]);
    $rain_data = $stmt->fetch();
    
    // Get recent reports
    $stmt = $db->prepare("SELECT COUNT(*) FROM laporan_warga 
                          WHERE dusun_id = ? AND jenis_laporan = 'kekeringan' 
                          AND tanggal >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)");
    $stmt->execute([$dusun['id']]);
    $report_count = $stmt->fetchColumn();
    
    // Calculate risk score (simple AI algorithm)
    $avg_rain = floatval($rain_data['avg_rain'] ?? 0);
    $rain_factor = max(0, min(100, (50 - $avg_rain) * 2)); // Lower rain = higher risk
    $report_factor = min(50, $report_count * 10); // More reports = higher risk
    
    $skor_risiko = ($rain_factor * 0.7) + ($report_factor * 0.3);
    
    // Determine risk level
    if ($skor_risiko >= 70) {
        $tingkat_risiko = 'kering';
        $rekomendasi = 'Segera lakukan distribusi air tangki. Warga diharapkan menghemat penggunaan air.';
    } elseif ($skor_risiko >= 40) {
        $tingkat_risiko = 'waspada';
        $rekomendasi = 'Mulai persiapkan distribusi air. Monitor kondisi setiap hari.';
    } else {
        $tingkat_risiko = 'aman';
        $rekomendasi = 'Kondisi normal. Tetap jaga ketersediaan air.';
    }
    
    $faktor_utama = [];
    if ($avg_rain < 20) $faktor_utama[] = 'Curah hujan rendah';
    if ($report_count > 0) $faktor_utama[] = 'Ada laporan kekeringan dari warga';
    if (empty($faktor_utama)) $faktor_utama[] = 'Kondisi normal';
    
    // Insert or update prediction
    $tanggal_prediksi = date('Y-m-d', strtotime('+7 days'));
    
    $stmt = $db->prepare("INSERT INTO prediksi_kekeringan 
                          (dusun_id, tanggal_prediksi, tingkat_risiko, skor_risiko, prediksi_hari, faktor_utama, rekomendasi) 
                          VALUES (?, ?, ?, ?, 7, ?, ?)
                          ON DUPLICATE KEY UPDATE 
                          tingkat_risiko = VALUES(tingkat_risiko),
                          skor_risiko = VALUES(skor_risiko),
                          faktor_utama = VALUES(faktor_utama),
                          rekomendasi = VALUES(rekomendasi)");
    
    if ($stmt->execute([
        $dusun['id'],
        $tanggal_prediksi,
        $tingkat_risiko,
        $skor_risiko,
        implode(', ', $faktor_utama),
        $rekomendasi
    ])) {
        $generated++;
        
        // Create notification for critical areas
        if ($tingkat_risiko === 'kering') {
            $stmt = $db->prepare("INSERT INTO notifikasi (user_id, judul, pesan, tipe) 
                                  VALUES (NULL, 'Peringatan Kekeringan', 
                                  'Dusun " . $dusun['nama_dusun'] . " diprediksi mengalami kekeringan. ' . $rekomendasi, 'danger')");
            $stmt->execute();
        }
    } else {
        $errors++;
    }
}

$_SESSION['success'] = "Prediksi berhasil dibuat untuk $generated dusun" . ($errors > 0 ? " ($errors error)" : "");
redirect('index.php');

