<?php
require_once '../config/config.php';

if (!isAdmin()) {
    redirect('../dashboard.php');
}

$db = Database::getInstance()->getConnection();

// Handle save config
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'save_config') {
    $app_name = sanitize($_POST['app_name'] ?? '');
    $app_desc = sanitize($_POST['app_desc'] ?? '');
    
    // Handle logo upload
    $app_logo = '';
    if (isset($_FILES['app_logo']) && $_FILES['app_logo']['error'] === UPLOAD_ERR_OK) {
        $upload_dir = '../uploads/logo/';
        if (!is_dir($upload_dir)) {
            mkdir($upload_dir, 0755, true);
        }
        
        $file_ext = strtolower(pathinfo($_FILES['app_logo']['name'], PATHINFO_EXTENSION));
        $allowed_ext = ['jpg', 'jpeg', 'png', 'gif', 'svg'];
        
        if (in_array($file_ext, $allowed_ext)) {
            $filename = 'logo_' . time() . '.' . $file_ext;
            $target_path = $upload_dir . $filename;
            
            if (move_uploaded_file($_FILES['app_logo']['tmp_name'], $target_path)) {
                $app_logo = 'uploads/logo/' . $filename;
                
                // Delete old logo
                $stmt = $db->query("SELECT config_value FROM app_config WHERE config_key = 'app_logo'");
                $old_logo = $stmt->fetchColumn();
                if ($old_logo && file_exists('../' . $old_logo) && $old_logo !== $app_logo) {
                    @unlink('../' . $old_logo);
                }
            }
        }
    } else {
        // Keep existing logo if not uploaded
        $stmt = $db->query("SELECT config_value FROM app_config WHERE config_key = 'app_logo'");
        $app_logo = $stmt->fetchColumn() ?? '';
    }
    
    // Handle favicon upload
    $app_favicon = '';
    if (isset($_FILES['app_favicon']) && $_FILES['app_favicon']['error'] === UPLOAD_ERR_OK) {
        $upload_dir = '../uploads/logo/';
        if (!is_dir($upload_dir)) {
            mkdir($upload_dir, 0755, true);
        }
        
        $file_ext = strtolower(pathinfo($_FILES['app_favicon']['name'], PATHINFO_EXTENSION));
        $allowed_ext = ['ico', 'png', 'jpg', 'jpeg', 'gif', 'svg'];
        
        if (in_array($file_ext, $allowed_ext)) {
            $filename = 'favicon_' . time() . '.' . $file_ext;
            $target_path = $upload_dir . $filename;
            
            if (move_uploaded_file($_FILES['app_favicon']['tmp_name'], $target_path)) {
                $app_favicon = 'uploads/logo/' . $filename;
                
                // Delete old favicon
                $stmt = $db->query("SELECT config_value FROM app_config WHERE config_key = 'app_favicon'");
                $old_favicon = $stmt->fetchColumn();
                if ($old_favicon && file_exists('../' . $old_favicon) && $old_favicon !== $app_favicon) {
                    @unlink('../' . $old_favicon);
                }
            }
        }
    } else {
        // Keep existing favicon if not uploaded
        $stmt = $db->query("SELECT config_value FROM app_config WHERE config_key = 'app_favicon'");
        $app_favicon = $stmt->fetchColumn() ?? '';
    }
    
    // Update config
    $configs = [
        'app_name' => $app_name,
        'app_desc' => $app_desc,
        'app_logo' => $app_logo,
        'app_favicon' => $app_favicon
    ];
    
    foreach ($configs as $key => $value) {
        $stmt = $db->prepare("INSERT INTO app_config (config_key, config_value) VALUES (?, ?) ON DUPLICATE KEY UPDATE config_value = ?");
        $stmt->execute([$key, $value, $value]);
    }
    
    $_SESSION['success'] = 'Pengaturan aplikasi berhasil disimpan';
    redirect('pengaturan.php');
}

// Get current config
$stmt = $db->query("SELECT config_key, config_value FROM app_config");
$app_config = $stmt->fetchAll(PDO::FETCH_KEY_PAIR);

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pengaturan Aplikasi - <?php echo APP_NAME; ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <?php include '../includes/sidebar.php'; ?>
    
    <main class="main-content">
        <header class="content-header">
            <div class="header-left">
                <h1><i class="fas fa-cog"></i> Pengaturan Aplikasi</h1>
                <p>Kelola logo, nama, dan konfigurasi aplikasi</p>
            </div>
        </header>

        <?php if (isset($_SESSION['success'])): ?>
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i> <?php echo $_SESSION['success']; unset($_SESSION['success']); ?>
        </div>
        <?php endif; ?>

        <?php if (isset($_SESSION['error'])): ?>
        <div class="alert alert-danger">
            <i class="fas fa-exclamation-circle"></i> <?php echo $_SESSION['error']; unset($_SESSION['error']); ?>
        </div>
        <?php endif; ?>

        <!-- App Settings Form -->
        <div class="content-section">
            <h2><i class="fas fa-info-circle"></i> Informasi Aplikasi</h2>
            <form method="POST" enctype="multipart/form-data" class="form-container">
                <input type="hidden" name="action" value="save_config">
                
                <div class="form-group">
                    <label>Nama Aplikasi <span style="color: red;">*</span></label>
                    <input type="text" name="app_name" value="<?php echo htmlspecialchars($app_config['app_name'] ?? 'SumberAI'); ?>" required>
                    <small style="color: #666;">Nama aplikasi akan ditampilkan di header dan title halaman</small>
                </div>
                
                <div class="form-group">
                    <label>Deskripsi Aplikasi</label>
                    <textarea name="app_desc" rows="3"><?php echo htmlspecialchars($app_config['app_desc'] ?? ''); ?></textarea>
                    <small style="color: #666;">Deskripsi singkat aplikasi</small>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label>Logo Aplikasi</label>
                        <input type="file" name="app_logo" accept="image/*" id="logo_input">
                        <?php if (!empty($app_config['app_logo'])): ?>
                        <div style="margin-top: 10px;">
                            <p><strong>Logo Saat Ini:</strong></p>
                            <img src="../<?php echo htmlspecialchars($app_config['app_logo']); ?>" alt="Logo" style="max-width: 200px; max-height: 100px; border: 1px solid #ddd; padding: 10px; border-radius: 5px;">
                        </div>
                        <?php endif; ?>
                        <small style="color: #666;">Format: JPG, PNG, GIF, SVG. Ukuran disarankan: 200x100px</small>
                    </div>
                    <div class="form-group">
                        <label>Favicon</label>
                        <input type="file" name="app_favicon" accept="image/*,.ico" id="favicon_input">
                        <?php if (!empty($app_config['app_favicon'])): ?>
                        <div style="margin-top: 10px;">
                            <p><strong>Favicon Saat Ini:</strong></p>
                            <img src="../<?php echo htmlspecialchars($app_config['app_favicon']); ?>" alt="Favicon" style="max-width: 32px; max-height: 32px; border: 1px solid #ddd; padding: 5px; border-radius: 3px;">
                        </div>
                        <?php endif; ?>
                        <small style="color: #666;">Format: ICO, PNG, JPG. Ukuran: 32x32px atau 16x16px</small>
                    </div>
                </div>
                
                <button type="submit" class="btn btn-primary btn-block">
                    <i class="fas fa-save"></i> Simpan Pengaturan
                </button>
            </form>
        </div>
    </main>

    <script src="../assets/js/main.js"></script>
    <script>
    // Preview logo
    document.getElementById('logo_input').addEventListener('change', function(e) {
        const file = e.target.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                const preview = document.createElement('div');
                preview.style.marginTop = '10px';
                preview.innerHTML = '<p><strong>Preview:</strong></p><img src="' + e.target.result + '" style="max-width: 200px; max-height: 100px; border: 1px solid #ddd; padding: 10px; border-radius: 5px;">';
                const existing = document.getElementById('logo_input').nextElementSibling;
                if (existing && existing.tagName === 'DIV' && existing.querySelector('strong') && existing.querySelector('strong').textContent === 'Preview:') {
                    existing.remove();
                }
                document.getElementById('logo_input').parentNode.insertBefore(preview, document.getElementById('logo_input').nextSibling);
            };
            reader.readAsDataURL(file);
        }
    });
    
    // Preview favicon
    document.getElementById('favicon_input').addEventListener('change', function(e) {
        const file = e.target.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                const preview = document.createElement('div');
                preview.style.marginTop = '10px';
                preview.innerHTML = '<p><strong>Preview:</strong></p><img src="' + e.target.result + '" style="max-width: 32px; max-height: 32px; border: 1px solid #ddd; padding: 5px; border-radius: 3px;">';
                const existing = document.getElementById('favicon_input').nextElementSibling;
                if (existing && existing.tagName === 'DIV' && existing.querySelector('strong') && existing.querySelector('strong').textContent === 'Preview:') {
                    existing.remove();
                }
                document.getElementById('favicon_input').parentNode.insertBefore(preview, document.getElementById('favicon_input').nextSibling);
            };
            reader.readAsDataURL(file);
        }
    });
    </script>
</body>
</html>

