<?php
require_once '../config/config.php';

if (!isAdmin()) {
    redirect('../dashboard.php');
}

$db = Database::getInstance()->getConnection();

// Handle save permissions
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'save_permissions') {
    $role = sanitize($_POST['role'] ?? '');
    $permissions = $_POST['permissions'] ?? [];
    
    // Delete existing permissions for this role
    $stmt = $db->prepare("DELETE FROM role_permissions WHERE role = ?");
    $stmt->execute([$role]);
    
    // Insert new permissions
    $stmt = $db->prepare("INSERT INTO role_permissions (role, permission_key, is_allowed) VALUES (?, ?, 1)");
    foreach ($permissions as $permission) {
        $stmt->execute([$role, sanitize($permission)]);
    }
    
    $_SESSION['success'] = 'Hak akses berhasil disimpan';
    redirect('hak_akses.php');
}

// Get all permissions
$all_permissions = [
    'view_prediksi' => 'Lihat Prediksi Kekeringan',
    'create_prediksi' => 'Buat Prediksi Kekeringan',
    'view_peta' => 'Lihat Peta Desa',
    'view_laporan' => 'Lihat Laporan Warga',
    'create_laporan' => 'Buat Laporan',
    'verify_laporan' => 'Verifikasi Laporan',
    'view_distribusi' => 'Lihat Distribusi Tangki',
    'manage_distribusi' => 'Kelola Distribusi Tangki',
    'approve_distribusi' => 'Approve Distribusi',
    'view_optimasi' => 'Lihat AI Optimasi',
    'manage_optimasi' => 'Kelola AI Optimasi',
    'view_depo' => 'Lihat Depo',
    'manage_depo' => 'Kelola Depo',
    'view_users' => 'Lihat Pengguna',
    'manage_users' => 'Kelola Pengguna',
    'view_desa' => 'Lihat Desa/Dusun',
    'manage_desa' => 'Kelola Desa/Dusun',
    'view_notifikasi' => 'Lihat Notifikasi',
    'manage_notifikasi' => 'Kelola Notifikasi',
    'view_laporan_sistem' => 'Lihat Laporan Sistem',
    'export_laporan' => 'Export Laporan',
    'view_pengaturan' => 'Lihat Pengaturan',
    'manage_pengaturan' => 'Kelola Pengaturan',
    'view_menu_icons' => 'Lihat Menu Icons',
    'manage_menu_icons' => 'Kelola Menu Icons',
    'view_wa_broadcast' => 'Lihat Broadcast WA',
    'manage_wa_broadcast' => 'Kelola Broadcast WA',
    'view_hak_akses' => 'Lihat Hak Akses',
    'manage_hak_akses' => 'Kelola Hak Akses'
];

// Get current permissions for each role
$roles = ['admin', 'pemdes', 'warga', 'petugas_tangki'];
$role_permissions = [];

foreach ($roles as $role) {
    $stmt = $db->prepare("SELECT permission_key FROM role_permissions WHERE role = ? AND is_allowed = 1");
    $stmt->execute([$role]);
    $role_permissions[$role] = $stmt->fetchAll(PDO::FETCH_COLUMN);
}

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hak Akses Pengguna - <?php echo APP_NAME; ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <?php include '../includes/sidebar.php'; ?>
    
    <main class="main-content">
        <header class="content-header">
            <div class="header-left">
                <h1><i class="fas fa-user-shield"></i> Hak Akses Pengguna</h1>
                <p>Kelola hak akses untuk setiap role pengguna</p>
            </div>
        </header>

        <?php if (isset($_SESSION['success'])): ?>
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i> <?php echo $_SESSION['success']; unset($_SESSION['success']); ?>
        </div>
        <?php endif; ?>

        <?php if (isset($_SESSION['error'])): ?>
        <div class="alert alert-danger">
            <i class="fas fa-exclamation-circle"></i> <?php echo $_SESSION['error']; unset($_SESSION['error']); ?>
        </div>
        <?php endif; ?>

        <div class="alert alert-info">
            <i class="fas fa-info-circle"></i> 
            <strong>Catatan:</strong> Admin memiliki semua hak akses secara default dan tidak dapat diubah.
        </div>

        <?php foreach ($roles as $role): ?>
        <?php if ($role === 'admin') continue; // Skip admin ?>
        <div class="content-section">
            <h2>
                <i class="fas fa-user-tag"></i> 
                Role: <?php echo ucfirst(str_replace('_', ' ', $role)); ?>
            </h2>
            <form method="POST" class="form-container">
                <input type="hidden" name="action" value="save_permissions">
                <input type="hidden" name="role" value="<?php echo $role; ?>">
                
                <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(250px, 1fr)); gap: 15px; margin-top: 20px;">
                    <?php foreach ($all_permissions as $key => $label): ?>
                    <div style="display: flex; align-items: center; padding: 10px; background: #f8f9fa; border-radius: 5px;">
                        <input type="checkbox" 
                               name="permissions[]" 
                               value="<?php echo $key; ?>" 
                               id="perm_<?php echo $role; ?>_<?php echo $key; ?>"
                               <?php echo in_array($key, $role_permissions[$role] ?? []) ? 'checked' : ''; ?>
                               style="margin-right: 10px;">
                        <label for="perm_<?php echo $role; ?>_<?php echo $key; ?>" style="margin: 0; cursor: pointer; flex: 1;">
                            <?php echo htmlspecialchars($label); ?>
                        </label>
                    </div>
                    <?php endforeach; ?>
                </div>
                
                <div style="margin-top: 20px; display: flex; gap: 10px;">
                    <button type="button" class="btn btn-secondary" onclick="selectAll('<?php echo $role; ?>')">
                        <i class="fas fa-check-square"></i> Pilih Semua
                    </button>
                    <button type="button" class="btn btn-secondary" onclick="deselectAll('<?php echo $role; ?>')">
                        <i class="fas fa-square"></i> Hapus Semua
                    </button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Simpan Hak Akses
                    </button>
                </div>
            </form>
        </div>
        <?php endforeach; ?>
    </main>

    <script src="../assets/js/main.js"></script>
    <script>
    function selectAll(role) {
        const checkboxes = document.querySelectorAll(`input[name="permissions[]"][id^="perm_${role}_"]`);
        checkboxes.forEach(cb => cb.checked = true);
    }
    
    function deselectAll(role) {
        const checkboxes = document.querySelectorAll(`input[name="permissions[]"][id^="perm_${role}_"]`);
        checkboxes.forEach(cb => cb.checked = false);
    }
    </script>
</body>
</html>

