<?php
require_once '../config/config.php';

if (!isLoggedIn()) {
    redirect('../index.php');
}

$id = intval($_GET['id'] ?? 0);
if (!$id) {
    redirect('index.php');
}

$db = Database::getInstance()->getConnection();

$stmt = $db->prepare("SELECT p.*, d.nama_dusun, d.rt, d.rw, d.alamat, d.latitude, d.longitude, des.nama_desa 
                      FROM prediksi_kekeringan p 
                      JOIN dusun d ON p.dusun_id = d.id 
                      JOIN desa des ON d.desa_id = des.id 
                      WHERE p.id = ?");
$stmt->execute([$id]);
$pred = $stmt->fetch();

if (!$pred) {
    redirect('index.php');
}

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detail Prediksi - <?php echo APP_NAME; ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <aside class="sidebar">
        <div class="sidebar-header">
            <h2><i class="fas fa-tint"></i> <?php echo APP_NAME; ?></h2>
        </div>
        <nav class="sidebar-nav">
            <a href="../dashboard.php" class="nav-item">
                <i class="fas fa-home"></i>
                <span>Dashboard</span>
            </a>
            <a href="index.php" class="nav-item active">
                <i class="fas fa-chart-line"></i>
                <span>Prediksi</span>
            </a>
            <a href="../auth/logout.php" class="nav-item">
                <i class="fas fa-sign-out-alt"></i>
                <span>Logout</span>
            </a>
        </nav>
    </aside>
    
    <main class="main-content">
        <header class="content-header">
            <div class="header-left">
                <h1><i class="fas fa-info-circle"></i> Detail Prediksi</h1>
                <p><?php echo htmlspecialchars($pred['nama_dusun']); ?></p>
            </div>
            <a href="index.php" class="btn btn-primary">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </header>

        <div class="content-section">
            <div class="form-row">
                <div class="form-group">
                    <label>Desa</label>
                    <input type="text" value="<?php echo htmlspecialchars($pred['nama_desa']); ?>" readonly>
                </div>
                <div class="form-group">
                    <label>Dusun</label>
                    <input type="text" value="<?php echo htmlspecialchars($pred['nama_dusun']); ?>" readonly>
                </div>
            </div>
            
            <div class="form-row">
                <div class="form-group">
                    <label>RT/RW</label>
                    <input type="text" value="<?php echo htmlspecialchars($pred['rt'] ?? '-'); ?>/<?php echo htmlspecialchars($pred['rw'] ?? '-'); ?>" readonly>
                </div>
                <div class="form-group">
                    <label>Tanggal Prediksi</label>
                    <input type="text" value="<?php echo formatDate($pred['tanggal_prediksi']); ?>" readonly>
                </div>
            </div>
            
            <div class="form-row">
                <div class="form-group">
                    <label>Tingkat Risiko</label>
                    <div>
                        <span class="badge badge-<?php echo $pred['tingkat_risiko'] === 'kering' ? 'danger' : ($pred['tingkat_risiko'] === 'waspada' ? 'warning' : 'success'); ?>" style="font-size: 1.2rem; padding: 10px 20px;">
                            <?php echo strtoupper($pred['tingkat_risiko']); ?>
                        </span>
                    </div>
                </div>
                <div class="form-group">
                    <label>Skor Risiko</label>
                    <input type="text" value="<?php echo number_format($pred['skor_risiko'], 2); ?>" readonly>
                </div>
            </div>
            
            <div class="form-group">
                <label>Faktor Utama</label>
                <textarea readonly rows="3"><?php echo htmlspecialchars($pred['faktor_utama']); ?></textarea>
            </div>
            
            <div class="form-group">
                <label>Rekomendasi</label>
                <div class="alert alert-<?php echo $pred['tingkat_risiko'] === 'kering' ? 'danger' : ($pred['tingkat_risiko'] === 'waspada' ? 'warning' : 'info'); ?>">
                    <i class="fas fa-lightbulb"></i> <?php echo htmlspecialchars($pred['rekomendasi']); ?>
                </div>
            </div>
            
            <?php if ($pred['latitude'] && $pred['longitude']): ?>
            <div class="form-group">
                <label>Lokasi</label>
                <div id="map" style="height: 400px;"></div>
            </div>
            <?php endif; ?>
        </div>
    </main>

    <?php if ($pred['latitude'] && $pred['longitude']): ?>
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
    <script>
    const map = L.map('map').setView([<?php echo $pred['latitude']; ?>, <?php echo $pred['longitude']; ?>], 15);
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '© OpenStreetMap contributors'
    }).addTo(map);
    
    L.marker([<?php echo $pred['latitude']; ?>, <?php echo $pred['longitude']; ?>])
        .addTo(map)
        .bindPopup('<?php echo htmlspecialchars($pred['nama_dusun']); ?>')
        .openPopup();
    </script>
    <?php endif; ?>

    <script src="../assets/js/main.js"></script>
</body>
</html>

