<?php
require_once '../config/config.php';

if (!isLoggedIn()) {
    redirect('../index.php');
}

$db = Database::getInstance()->getConnection();

// Handle create report
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'create') {
    $dusun_id = intval($_POST['dusun_id'] ?? 0);
    $tanggal = sanitize($_POST['tanggal'] ?? date('Y-m-d'));
    $jenis_laporan = sanitize($_POST['jenis_laporan'] ?? 'kekeringan');
    $sumber_air = sanitize($_POST['sumber_air'] ?? 'lainnya');
    $deskripsi = sanitize($_POST['deskripsi'] ?? '');
    $foto = sanitize($_POST['foto'] ?? '');
    $latitude = floatval($_POST['latitude'] ?? 0);
    $longitude = floatval($_POST['longitude'] ?? 0);
    
    if ($dusun_id > 0 && !empty($deskripsi)) {
        $stmt = $db->prepare("INSERT INTO laporan_warga (user_id, dusun_id, tanggal, jenis_laporan, sumber_air, deskripsi, foto, latitude, longitude) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        if ($stmt->execute([$_SESSION['user_id'], $dusun_id, $tanggal, $jenis_laporan, $sumber_air, $deskripsi, $foto, $latitude, $longitude])) {
            $_SESSION['success'] = 'Laporan berhasil dikirim';
        } else {
            $_SESSION['error'] = 'Gagal mengirim laporan';
        }
    } else {
        $_SESSION['error'] = 'Data tidak lengkap';
    }
    
    redirect('index.php');
}

// Get reports
$where = "1=1";
if (!isAdmin() && getUserRole() !== 'pemdes') {
    $where = "l.user_id = " . intval($_SESSION['user_id']);
}

$stmt = $db->query("SELECT l.*, u.nama_lengkap, u.no_ktp, u.provinsi, u.kabupaten, u.kelurahan, u.rt, u.rw, u.email, u.no_hp, d.nama_dusun, des.nama_desa 
                    FROM laporan_warga l 
                    JOIN users u ON l.user_id = u.id 
                    JOIN dusun d ON l.dusun_id = d.id 
                    JOIN desa des ON d.desa_id = des.id 
                    WHERE $where 
                    ORDER BY l.created_at DESC");
$reports = $stmt->fetchAll();

// Get dusun list for form
$stmt = $db->query("SELECT d.*, des.nama_desa FROM dusun d JOIN desa des ON d.desa_id = des.id ORDER BY des.nama_desa, d.nama_dusun");
$dusun_list = $stmt->fetchAll();

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Laporan Warga - <?php echo APP_NAME; ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <aside class="sidebar">
        <div class="sidebar-header">
            <h2><i class="fas fa-tint"></i> <?php echo APP_NAME; ?></h2>
        </div>
        <nav class="sidebar-nav">
            <a href="../dashboard.php" class="nav-item">
                <i class="fas fa-home"></i>
                <span>Dashboard</span>
            </a>
            <a href="../prediksi/index.php" class="nav-item">
                <i class="fas fa-chart-line"></i>
                <span>Prediksi</span>
            </a>
            <a href="index.php" class="nav-item active">
                <i class="fas fa-file-alt"></i>
                <span>Laporan</span>
            </a>
            <a href="../auth/logout.php" class="nav-item">
                <i class="fas fa-sign-out-alt"></i>
                <span>Logout</span>
            </a>
        </nav>
    </aside>
    
    <main class="main-content">
        <header class="content-header">
            <div class="header-left">
                <h1><i class="fas fa-file-alt"></i> Laporan Warga</h1>
                <p>Kirim laporan kondisi air di daerah Anda</p>
            </div>
            <button class="btn btn-primary" onclick="document.getElementById('createModal').style.display='block'">
                <i class="fas fa-plus"></i> Buat Laporan
            </button>
        </header>

        <?php if (isset($_SESSION['success'])): ?>
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i> <?php echo $_SESSION['success']; unset($_SESSION['success']); ?>
        </div>
        <?php endif; ?>

        <?php if (isset($_SESSION['error'])): ?>
        <div class="alert alert-danger">
            <i class="fas fa-exclamation-circle"></i> <?php echo $_SESSION['error']; unset($_SESSION['error']); ?>
        </div>
        <?php endif; ?>

        <div class="content-section">
            <div class="table-responsive">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>Tanggal</th>
                            <th>Pelapor</th>
                            <th>No. KTP</th>
                            <th>Alamat</th>
                            <th>Desa/Dusun</th>
                            <th>Sumber Air</th>
                            <th>Jenis</th>
                            <th>Foto</th>
                            <th>Deskripsi</th>
                            <th>Status</th>
                            <?php if (isAdmin() || getUserRole() === 'pemdes'): ?>
                            <th>Aksi</th>
                            <?php endif; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($reports)): ?>
                        <tr>
                            <td colspan="<?php echo (isAdmin() || getUserRole() === 'pemdes') ? '11' : '10'; ?>" class="text-center">Belum ada laporan</td>
                        </tr>
                        <?php else: ?>
                        <?php foreach ($reports as $report): ?>
                        <tr>
                            <td><?php echo formatDate($report['tanggal']); ?></td>
                            <td><?php echo htmlspecialchars($report['nama_lengkap']); ?></td>
                            <td><?php echo htmlspecialchars($report['no_ktp'] ?? '-'); ?></td>
                            <td>
                                <?php 
                                $alamat_parts = [];
                                if (!empty($report['rt'])) $alamat_parts[] = 'RT ' . $report['rt'];
                                if (!empty($report['rw'])) $alamat_parts[] = 'RW ' . $report['rw'];
                                if (!empty($report['kelurahan'])) $alamat_parts[] = $report['kelurahan'];
                                if (!empty($report['kabupaten'])) $alamat_parts[] = $report['kabupaten'];
                                echo htmlspecialchars(implode(', ', $alamat_parts) ?: '-');
                                ?>
                            </td>
                            <td><?php echo htmlspecialchars($report['nama_desa']); ?> - <?php echo htmlspecialchars($report['nama_dusun']); ?></td>
                            <td>
                                <span class="badge badge-info"><?php echo ucfirst($report['sumber_air'] ?? 'lainnya'); ?></span>
                            </td>
                            <td>
                                <span class="badge badge-info"><?php echo ucfirst(str_replace('_', ' ', $report['jenis_laporan'])); ?></span>
                            </td>
                            <td>
                                <?php if (!empty($report['foto'])): ?>
                                <a href="detail.php?id=<?php echo $report['id']; ?>" class="btn btn-sm btn-primary">
                                    <i class="fas fa-image"></i> Lihat
                                </a>
                                <?php else: ?>
                                <span class="badge badge-warning">Tidak ada</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php echo htmlspecialchars(substr($report['deskripsi'], 0, 50)) . (strlen($report['deskripsi']) > 50 ? '...' : ''); ?>
                                <br>
                                <a href="detail.php?id=<?php echo $report['id']; ?>" class="btn btn-sm btn-link" style="padding: 0; margin-top: 5px;">
                                    <i class="fas fa-eye"></i> Detail
                                </a>
                            </td>
                            <td>
                                <span class="badge badge-<?php echo $report['status'] === 'verified' ? 'success' : ($report['status'] === 'rejected' ? 'danger' : 'warning'); ?>">
                                    <?php echo ucfirst($report['status']); ?>
                                </span>
                            </td>
                            <?php if (isAdmin() || getUserRole() === 'pemdes'): ?>
                            <td>
                                <form method="POST" style="display:inline;">
                                    <input type="hidden" name="action" value="verify">
                                    <input type="hidden" name="report_id" value="<?php echo $report['id']; ?>">
                                    <input type="hidden" name="status" value="verified">
                                    <button type="submit" class="btn btn-sm btn-success">
                                        <i class="fas fa-check"></i>
                                    </button>
                                </form>
                                <form method="POST" style="display:inline;">
                                    <input type="hidden" name="action" value="verify">
                                    <input type="hidden" name="report_id" value="<?php echo $report['id']; ?>">
                                    <input type="hidden" name="status" value="rejected">
                                    <button type="submit" class="btn btn-sm btn-danger">
                                        <i class="fas fa-times"></i>
                                    </button>
                                </form>
                            </td>
                            <?php endif; ?>
                        </tr>
                        <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </main>

    <!-- Create Modal -->
    <div id="createModal" class="modal" style="display:none;">
        <div class="modal-content">
            <span class="close" onclick="document.getElementById('createModal').style.display='none'">&times;</span>
            <h2>Buat Laporan</h2>
            <form method="POST" class="form-container" id="laporanForm" enctype="multipart/form-data">
                <input type="hidden" name="action" value="create">
                <input type="hidden" name="foto" id="foto_path">
                <input type="hidden" name="latitude" id="report_latitude">
                <input type="hidden" name="longitude" id="report_longitude">
                
                <div class="form-group">
                    <label>Dusun</label>
                    <select name="dusun_id" required>
                        <option value="">Pilih Dusun</option>
                        <?php foreach ($dusun_list as $dusun): ?>
                        <option value="<?php echo $dusun['id']; ?>"><?php echo htmlspecialchars($dusun['nama_desa']); ?> - <?php echo htmlspecialchars($dusun['nama_dusun']); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="form-group">
                    <label>Sumber Air</label>
                    <select name="sumber_air" required>
                        <option value="penampungan">Penampungan</option>
                        <option value="sumur">Sumur</option>
                        <option value="pam">PAM</option>
                        <option value="lainnya">Lainnya</option>
                    </select>
                </div>
                
                <div class="form-group">
                    <label>Tanggal</label>
                    <input type="date" name="tanggal" value="<?php echo date('Y-m-d'); ?>" required>
                </div>
                
                <div class="form-group">
                    <label>Jenis Laporan</label>
                    <select name="jenis_laporan" required>
                        <option value="kekeringan">Kekeringan</option>
                        <option value="ketersediaan_air">Ketersediaan Air</option>
                        <option value="kualitas_air">Kualitas Air</option>
                        <option value="penampungan">Penampungan</option>
                        <option value="sumur">Sumur</option>
                        <option value="pam">PAM</option>
                        <option value="lainnya">Lainnya</option>
                    </select>
                </div>
                
                <div class="form-group">
                    <label>Upload Foto</label>
                    <div style="display: flex; gap: 10px; margin-bottom: 10px;">
                        <input type="file" id="foto_input" accept="image/*" capture="environment" style="flex: 1;">
                        <button type="button" class="btn btn-secondary" onclick="document.getElementById('foto_input').click()">
                            <i class="fas fa-camera"></i> Ambil Foto
                        </button>
                    </div>
                    <small style="color: #666;">Anda dapat mengambil foto langsung dari kamera atau memilih dari galeri</small>
                    <div id="foto_preview" style="margin-top: 10px; display: none;">
                        <img id="preview_img" src="" alt="Preview" style="max-width: 100%; max-height: 200px; border-radius: 8px;">
                        <button type="button" class="btn btn-sm btn-danger" onclick="removeFoto()" style="margin-top: 10px;">
                            <i class="fas fa-times"></i> Hapus Foto
                        </button>
                    </div>
                </div>
                
                <div class="form-group">
                    <label>Koordinat GPS</label>
                    <div class="form-row">
                        <div class="form-group">
                            <label>Latitude</label>
                            <input type="text" id="lat_display" readonly style="background: #f5f5f5;">
                        </div>
                        <div class="form-group">
                            <label>Longitude</label>
                            <input type="text" id="lng_display" readonly style="background: #f5f5f5;">
                        </div>
                    </div>
                    <button type="button" class="btn btn-sm btn-primary" onclick="getLocation()">
                        <i class="fas fa-map-marker-alt"></i> Ambil Koordinat
                    </button>
                    <small style="color: #666; display: block; margin-top: 5px;">Koordinat akan diambil otomatis dari GPS perangkat Anda</small>
                </div>
                
                <div class="form-group">
                    <label>Deskripsi</label>
                    <textarea name="deskripsi" rows="5" required placeholder="Jelaskan kondisi yang Anda temui..."></textarea>
                </div>
                
                <button type="submit" class="btn btn-primary btn-block">
                    <i class="fas fa-paper-plane"></i> Kirim Laporan
                </button>
            </form>
        </div>
    </div>

    <?php
    // Handle verify
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'verify') {
        if (isAdmin() || getUserRole() === 'pemdes') {
            $report_id = intval($_POST['report_id'] ?? 0);
            $status = sanitize($_POST['status'] ?? 'verified');
            
            $stmt = $db->prepare("UPDATE laporan_warga SET status = ? WHERE id = ?");
            if ($stmt->execute([$status, $report_id])) {
                $_SESSION['success'] = 'Status laporan berhasil diupdate';
            } else {
                $_SESSION['error'] = 'Gagal update status';
            }
            redirect('index.php');
        }
    }
    ?>

    <script src="../assets/js/main.js"></script>
    <script>
    let currentFoto = null;
    
    // Get GPS Location
    function getLocation() {
        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(
                function(position) {
                    const lat = position.coords.latitude;
                    const lng = position.coords.longitude;
                    
                    document.getElementById('report_latitude').value = lat;
                    document.getElementById('report_longitude').value = lng;
                    document.getElementById('lat_display').value = lat.toFixed(6);
                    document.getElementById('lng_display').value = lng.toFixed(6);
                    
                    showToast('Koordinat berhasil diambil', 'success');
                },
                function(error) {
                    showToast('Gagal mengambil koordinat: ' + error.message, 'danger');
                }
            );
        } else {
            showToast('GPS tidak didukung di perangkat ini', 'warning');
        }
    }
    
    // Auto get location on page load
    window.addEventListener('load', function() {
        getLocation();
    });
    
    // Handle foto upload
    document.getElementById('foto_input').addEventListener('change', function(e) {
        const file = e.target.files[0];
        if (file) {
            const formData = new FormData();
            formData.append('foto', file);
            
            // Show loading
            const preview = document.getElementById('foto_preview');
            preview.innerHTML = '<div class="loading"></div> Uploading...';
            preview.style.display = 'block';
            
            fetch('upload.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    currentFoto = data.path;
                    document.getElementById('foto_path').value = data.path;
                    document.getElementById('preview_img').src = '../' + data.path;
                    preview.innerHTML = `
                        <img id="preview_img" src="../${data.path}" alt="Preview" style="max-width: 100%; max-height: 200px; border-radius: 8px;">
                        <button type="button" class="btn btn-sm btn-danger" onclick="removeFoto()" style="margin-top: 10px;">
                            <i class="fas fa-times"></i> Hapus Foto
                        </button>
                    `;
                    showToast('Foto berhasil diupload', 'success');
                } else {
                    preview.style.display = 'none';
                    showToast(data.message || 'Gagal upload foto', 'danger');
                }
            })
            .catch(error => {
                preview.style.display = 'none';
                showToast('Error: ' + error.message, 'danger');
            });
        }
    });
    
    function removeFoto() {
        currentFoto = null;
        document.getElementById('foto_path').value = '';
        document.getElementById('foto_input').value = '';
        document.getElementById('foto_preview').style.display = 'none';
    }
    
    // Form submit
    document.getElementById('laporanForm').addEventListener('submit', function(e) {
        if (!document.getElementById('report_latitude').value || !document.getElementById('report_longitude').value) {
            e.preventDefault();
            if (confirm('Koordinat GPS belum diambil. Lanjutkan tanpa koordinat?')) {
                document.getElementById('report_latitude').value = 0;
                document.getElementById('report_longitude').value = 0;
                this.submit();
            }
        }
    });
    </script>
    <style>
    .modal {
        display: none;
        position: fixed;
        z-index: 1000;
        left: 0;
        top: 0;
        width: 100%;
        height: 100%;
        background: rgba(0,0,0,0.5);
        overflow-y: auto;
    }
    
    .modal-content {
        background: white;
        margin: 5% auto;
        padding: 30px;
        border-radius: 15px;
        width: 90%;
        max-width: 600px;
    }
    
    .close {
        float: right;
        font-size: 28px;
        font-weight: bold;
        cursor: pointer;
        color: #999;
    }
    
    #foto_preview img {
        border: 2px solid #ddd;
        padding: 5px;
    }
    </style>
</body>
</html>

