<?php
require_once '../config/config.php';

if (!isAdmin()) {
    redirect('../dashboard.php');
}

$db = Database::getInstance()->getConnection();

// Handle actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    
    if ($action === 'create') {
        $username = sanitize($_POST['username'] ?? '');
        $nama_lengkap = sanitize($_POST['nama_lengkap'] ?? '');
        $email = sanitize($_POST['email'] ?? '');
        $no_hp = sanitize($_POST['no_hp'] ?? '');
        $no_ktp = sanitize($_POST['no_ktp'] ?? '');
        $provinsi = sanitize($_POST['provinsi'] ?? '');
        $kabupaten = sanitize($_POST['kabupaten'] ?? '');
        $kelurahan = sanitize($_POST['kelurahan'] ?? '');
        $dusun_id = intval($_POST['dusun_id'] ?? 0);
        $rt = sanitize($_POST['rt'] ?? '');
        $rw = sanitize($_POST['rw'] ?? '');
        $role = sanitize($_POST['role'] ?? 'warga');
        $password = $_POST['password'] ?? '';
        
        if (empty($username) || empty($nama_lengkap) || empty($password)) {
            $_SESSION['error'] = 'Data wajib harus diisi';
        } else {
            // Check username
            $stmt = $db->prepare("SELECT id FROM users WHERE username = ?");
            $stmt->execute([$username]);
            if ($stmt->fetch()) {
                $_SESSION['error'] = 'Username sudah digunakan';
            } elseif (!empty($no_ktp)) {
                // Check KTP
                $stmt = $db->prepare("SELECT id FROM users WHERE no_ktp = ?");
                $stmt->execute([$no_ktp]);
                if ($stmt->fetch()) {
                    $_SESSION['error'] = 'Nomor KTP sudah terdaftar';
                } else {
                    $hashed_password = password_hash($password, PASSWORD_DEFAULT);
                    $stmt = $db->prepare("INSERT INTO users (username, password, nama_lengkap, email, no_hp, no_ktp, provinsi, kabupaten, kelurahan, dusun_id, rt, rw, role) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                    if ($stmt->execute([$username, $hashed_password, $nama_lengkap, $email, $no_hp, $no_ktp, $provinsi, $kabupaten, $kelurahan, $dusun_id > 0 ? $dusun_id : null, $rt, $rw, $role])) {
                        $_SESSION['success'] = 'Akun berhasil dibuat';
                    } else {
                        $_SESSION['error'] = 'Gagal membuat akun';
                    }
                }
            } else {
                $hashed_password = password_hash($password, PASSWORD_DEFAULT);
                $stmt = $db->prepare("INSERT INTO users (username, password, nama_lengkap, email, no_hp, no_ktp, provinsi, kabupaten, kelurahan, dusun_id, rt, rw, role) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                if ($stmt->execute([$username, $hashed_password, $nama_lengkap, $email, $no_hp, $no_ktp, $provinsi, $kabupaten, $kelurahan, $dusun_id > 0 ? $dusun_id : null, $rt, $rw, $role])) {
                    $_SESSION['success'] = 'Akun berhasil dibuat';
                } else {
                    $_SESSION['error'] = 'Gagal membuat akun';
                }
            }
        }
    } elseif ($action === 'reset_password') {
        $user_id = intval($_POST['user_id'] ?? 0);
        $new_password = $_POST['new_password'] ?? 'admin123';
        
        $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
        $stmt = $db->prepare("UPDATE users SET password = ? WHERE id = ?");
        if ($stmt->execute([$hashed_password, $user_id])) {
            $_SESSION['success'] = 'Password berhasil direset';
        } else {
            $_SESSION['error'] = 'Gagal reset password';
        }
    } elseif ($action === 'update') {
        $user_id = intval($_POST['user_id'] ?? 0);
        $username = sanitize($_POST['username'] ?? '');
        $nama_lengkap = sanitize($_POST['nama_lengkap'] ?? '');
        $email = sanitize($_POST['email'] ?? '');
        $no_hp = sanitize($_POST['no_hp'] ?? '');
        $no_ktp = sanitize($_POST['no_ktp'] ?? '');
        $provinsi = sanitize($_POST['provinsi'] ?? '');
        $kabupaten = sanitize($_POST['kabupaten'] ?? '');
        $kelurahan = sanitize($_POST['kelurahan'] ?? '');
        $dusun_id = intval($_POST['dusun_id'] ?? 0);
        $rt = sanitize($_POST['rt'] ?? '');
        $rw = sanitize($_POST['rw'] ?? '');
        $role = sanitize($_POST['role'] ?? 'warga');
        $status = sanitize($_POST['status'] ?? 'active');
        
        // Check KTP if changed
        if (!empty($no_ktp)) {
            $stmt = $db->prepare("SELECT id FROM users WHERE no_ktp = ? AND id != ?");
            $stmt->execute([$no_ktp, $user_id]);
            if ($stmt->fetch()) {
                $_SESSION['error'] = 'Nomor KTP sudah terdaftar';
                redirect('users.php');
            }
        }
        
        $stmt = $db->prepare("UPDATE users SET username = ?, nama_lengkap = ?, email = ?, no_hp = ?, no_ktp = ?, provinsi = ?, kabupaten = ?, kelurahan = ?, dusun_id = ?, rt = ?, rw = ?, role = ?, status = ? WHERE id = ?");
        if ($stmt->execute([$username, $nama_lengkap, $email, $no_hp, $no_ktp, $provinsi, $kabupaten, $kelurahan, $dusun_id > 0 ? $dusun_id : null, $rt, $rw, $role, $status, $user_id])) {
            $_SESSION['success'] = 'Data berhasil diupdate';
        } else {
            $_SESSION['error'] = 'Gagal update data';
        }
    } elseif ($action === 'delete') {
        $user_id = intval($_POST['user_id'] ?? 0);
        $stmt = $db->prepare("DELETE FROM users WHERE id = ? AND id != ?");
        if ($stmt->execute([$user_id, $_SESSION['user_id']])) {
            $_SESSION['success'] = 'Akun berhasil dihapus';
        } else {
            $_SESSION['error'] = 'Gagal menghapus akun';
        }
    }
    
    redirect('users.php');
}

// Get all users with dusun info
$stmt = $db->query("SELECT u.*, d.nama_dusun, des.nama_desa 
                    FROM users u 
                    LEFT JOIN dusun d ON u.dusun_id = d.id 
                    LEFT JOIN desa des ON d.desa_id = des.id 
                    ORDER BY u.created_at DESC");
$users = $stmt->fetchAll();

// Get dusun list for dropdown
$stmt = $db->query("SELECT d.*, des.nama_desa FROM dusun d JOIN desa des ON d.desa_id = des.id ORDER BY des.nama_desa, d.nama_dusun");
$dusun_list = $stmt->fetchAll();

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kelola Pengguna - <?php echo APP_NAME; ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <aside class="sidebar">
        <div class="sidebar-header">
            <h2><i class="fas fa-tint"></i> <?php echo APP_NAME; ?></h2>
        </div>
        <nav class="sidebar-nav">
            <a href="../dashboard.php" class="nav-item">
                <i class="fas fa-home"></i>
                <span>Dashboard</span>
            </a>
            <a href="users.php" class="nav-item active">
                <i class="fas fa-users"></i>
                <span>Kelola Pengguna</span>
            </a>
            <a href="desa.php" class="nav-item">
                <i class="fas fa-building"></i>
                <span>Kelola Desa</span>
            </a>
            <a href="menu_icons.php" class="nav-item">
                <i class="fas fa-palette"></i>
                <span>Kelola Menu</span>
            </a>
            <a href="../auth/logout.php" class="nav-item">
                <i class="fas fa-sign-out-alt"></i>
                <span>Logout</span>
            </a>
        </nav>
    </aside>
    
    <main class="main-content">
        <header class="content-header">
            <div class="header-left">
                <h1><i class="fas fa-users"></i> Kelola Pengguna</h1>
                <p>Manajemen akun pengguna sistem</p>
            </div>
            <button class="btn btn-primary" onclick="document.getElementById('createModal').style.display='block'">
                <i class="fas fa-user-plus"></i> Tambah Pengguna
            </button>
        </header>

        <?php if (isset($_SESSION['success'])): ?>
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i> <?php echo $_SESSION['success']; unset($_SESSION['success']); ?>
        </div>
        <?php endif; ?>

        <?php if (isset($_SESSION['error'])): ?>
        <div class="alert alert-danger">
            <i class="fas fa-exclamation-circle"></i> <?php echo $_SESSION['error']; unset($_SESSION['error']); ?>
        </div>
        <?php endif; ?>

        <div class="content-section">
            <div class="table-responsive">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>Username</th>
                            <th>Nama Lengkap</th>
                            <th>No. KTP</th>
                            <th>Alamat</th>
                            <th>Email</th>
                            <th>No. HP</th>
                            <th>Role</th>
                            <th>Status</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($users as $user): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($user['username']); ?></td>
                            <td><?php echo htmlspecialchars($user['nama_lengkap']); ?></td>
                            <td><?php echo htmlspecialchars($user['no_ktp'] ?? '-'); ?></td>
                            <td>
                                <?php 
                                $alamat_parts = [];
                                if (!empty($user['rt'])) $alamat_parts[] = 'RT ' . $user['rt'];
                                if (!empty($user['rw'])) $alamat_parts[] = 'RW ' . $user['rw'];
                                if (!empty($user['nama_dusun'])) $alamat_parts[] = $user['nama_dusun'];
                                if (!empty($user['kelurahan'])) $alamat_parts[] = $user['kelurahan'];
                                if (!empty($user['kabupaten'])) $alamat_parts[] = $user['kabupaten'];
                                echo htmlspecialchars(implode(', ', $alamat_parts) ?: '-');
                                ?>
                            </td>
                            <td><?php echo htmlspecialchars($user['email'] ?? '-'); ?></td>
                            <td><?php echo htmlspecialchars($user['no_hp'] ?? '-'); ?></td>
                            <td>
                                <span class="badge badge-info"><?php echo ucfirst($user['role']); ?></span>
                            </td>
                            <td>
                                <span class="badge badge-<?php echo $user['status'] === 'active' ? 'success' : 'danger'; ?>">
                                    <?php echo ucfirst($user['status']); ?>
                                </span>
                            </td>
                            <td>
                                <button class="btn btn-sm btn-primary" onclick="editUser(<?php echo htmlspecialchars(json_encode($user)); ?>)">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <button class="btn btn-sm btn-warning" onclick="resetPassword(<?php echo $user['id']; ?>)">
                                    <i class="fas fa-key"></i>
                                </button>
                                <?php if ($user['id'] != $_SESSION['user_id']): ?>
                                <button class="btn btn-sm btn-danger" onclick="deleteUser(<?php echo $user['id']; ?>)">
                                    <i class="fas fa-trash"></i>
                                </button>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </main>

    <!-- Create Modal -->
    <div id="createModal" class="modal" style="display:none;">
        <div class="modal-content">
            <span class="close" onclick="document.getElementById('createModal').style.display='none'">&times;</span>
            <h2>Tambah Pengguna</h2>
            <form method="POST" class="form-container">
                <input type="hidden" name="action" value="create">
                <div class="form-group">
                    <label>Username</label>
                    <input type="text" name="username" required>
                </div>
                <div class="form-group">
                    <label>Nama Lengkap</label>
                    <input type="text" name="nama_lengkap" required>
                </div>
                <div class="form-group">
                    <label>Nomor KTP</label>
                    <input type="text" name="no_ktp" maxlength="16" pattern="[0-9]{16}" placeholder="16 digit angka">
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label>Provinsi</label>
                        <input type="text" name="provinsi" placeholder="Contoh: DI Yogyakarta">
                    </div>
                    <div class="form-group">
                        <label>Kabupaten</label>
                        <input type="text" name="kabupaten" placeholder="Contoh: Gunungkidul">
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label>Kelurahan</label>
                        <input type="text" name="kelurahan" placeholder="Nama Kelurahan">
                    </div>
                    <div class="form-group">
                        <label>Dusun</label>
                        <select name="dusun_id">
                            <option value="">Pilih Dusun</option>
                            <?php foreach ($dusun_list as $dusun): ?>
                            <option value="<?php echo $dusun['id']; ?>"><?php echo htmlspecialchars($dusun['nama_desa']); ?> - <?php echo htmlspecialchars($dusun['nama_dusun']); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label>RT</label>
                        <input type="text" name="rt" placeholder="Contoh: 01" maxlength="10">
                    </div>
                    <div class="form-group">
                        <label>RW</label>
                        <input type="text" name="rw" placeholder="Contoh: 05" maxlength="10">
                    </div>
                </div>
                <div class="form-group">
                    <label>Email</label>
                    <input type="email" name="email">
                </div>
                <div class="form-group">
                    <label>No. HP</label>
                    <input type="text" name="no_hp" placeholder="Contoh: 081234567890">
                </div>
                <div class="form-group">
                    <label>Role</label>
                    <select name="role" required>
                        <option value="warga">Warga</option>
                        <option value="pemdes">Pemdes</option>
                        <option value="petugas_tangki">Petugas Tangki</option>
                        <option value="admin">Admin</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>Password</label>
                    <input type="password" name="password" required minlength="6">
                </div>
                <button type="submit" class="btn btn-primary btn-block">Simpan</button>
            </form>
        </div>
    </div>

    <script src="../assets/js/main.js"></script>
    <script>
    function editUser(user) {
        document.getElementById('editModal').style.display = 'block';
        document.getElementById('edit_user_id').value = user.id;
        document.getElementById('edit_username').value = user.username;
        document.getElementById('edit_nama_lengkap').value = user.nama_lengkap;
        document.getElementById('edit_no_ktp').value = user.no_ktp || '';
        document.getElementById('edit_provinsi').value = user.provinsi || '';
        document.getElementById('edit_kabupaten').value = user.kabupaten || '';
        document.getElementById('edit_kelurahan').value = user.kelurahan || '';
        document.getElementById('edit_dusun_id').value = user.dusun_id || '';
        document.getElementById('edit_rt').value = user.rt || '';
        document.getElementById('edit_rw').value = user.rw || '';
        document.getElementById('edit_email').value = user.email || '';
        document.getElementById('edit_no_hp').value = user.no_hp || '';
        document.getElementById('edit_role').value = user.role;
        document.getElementById('edit_status').value = user.status;
    }
    
    function resetPassword(userId) {
        if (confirm('Reset password untuk user ini?')) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.innerHTML = `
                <input type="hidden" name="action" value="reset_password">
                <input type="hidden" name="user_id" value="${userId}">
                <input type="hidden" name="new_password" value="admin123">
            `;
            document.body.appendChild(form);
            form.submit();
        }
    }
    
    function deleteUser(userId) {
        if (confirm('Hapus user ini?')) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.innerHTML = `
                <input type="hidden" name="action" value="delete">
                <input type="hidden" name="user_id" value="${userId}">
            `;
            document.body.appendChild(form);
            form.submit();
        }
    }
    </script>
    
    <!-- Edit Modal -->
    <div id="editModal" class="modal" style="display:none;">
        <div class="modal-content">
            <span class="close" onclick="document.getElementById('editModal').style.display='none'">&times;</span>
            <h2>Edit Pengguna</h2>
            <form method="POST" class="form-container">
                <input type="hidden" name="action" value="update">
                <input type="hidden" name="user_id" id="edit_user_id">
                <div class="form-group">
                    <label>Username</label>
                    <input type="text" name="username" id="edit_username" required>
                </div>
                <div class="form-group">
                    <label>Nama Lengkap</label>
                    <input type="text" name="nama_lengkap" id="edit_nama_lengkap" required>
                </div>
                <div class="form-group">
                    <label>Nomor KTP</label>
                    <input type="text" name="no_ktp" id="edit_no_ktp" maxlength="16" pattern="[0-9]{16}" placeholder="16 digit angka">
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label>Provinsi</label>
                        <input type="text" name="provinsi" id="edit_provinsi" placeholder="Contoh: DI Yogyakarta">
                    </div>
                    <div class="form-group">
                        <label>Kabupaten</label>
                        <input type="text" name="kabupaten" id="edit_kabupaten" placeholder="Contoh: Gunungkidul">
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label>Kelurahan</label>
                        <input type="text" name="kelurahan" id="edit_kelurahan" placeholder="Nama Kelurahan">
                    </div>
                    <div class="form-group">
                        <label>Dusun</label>
                        <select name="dusun_id" id="edit_dusun_id">
                            <option value="">Pilih Dusun</option>
                            <?php foreach ($dusun_list as $dusun): ?>
                            <option value="<?php echo $dusun['id']; ?>"><?php echo htmlspecialchars($dusun['nama_desa']); ?> - <?php echo htmlspecialchars($dusun['nama_dusun']); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label>RT</label>
                        <input type="text" name="rt" id="edit_rt" placeholder="Contoh: 01" maxlength="10">
                    </div>
                    <div class="form-group">
                        <label>RW</label>
                        <input type="text" name="rw" id="edit_rw" placeholder="Contoh: 05" maxlength="10">
                    </div>
                </div>
                <div class="form-group">
                    <label>Email</label>
                    <input type="email" name="email" id="edit_email">
                </div>
                <div class="form-group">
                    <label>No. HP</label>
                    <input type="text" name="no_hp" id="edit_no_hp" placeholder="Contoh: 081234567890">
                </div>
                <div class="form-group">
                    <label>Role</label>
                    <select name="role" id="edit_role" required>
                        <option value="warga">Warga</option>
                        <option value="pemdes">Pemdes</option>
                        <option value="petugas_tangki">Petugas Tangki</option>
                        <option value="admin">Admin</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>Status</label>
                    <select name="status" id="edit_status" required>
                        <option value="active">Active</option>
                        <option value="inactive">Inactive</option>
                    </select>
                </div>
                <button type="submit" class="btn btn-primary btn-block">Update</button>
            </form>
        </div>
    </div>
    
    <style>
    .modal {
        display: none;
        position: fixed;
        z-index: 1000;
        left: 0;
        top: 0;
        width: 100%;
        height: 100%;
        background: rgba(0,0,0,0.5);
    }
    
    .modal-content {
        background: white;
        margin: 5% auto;
        padding: 30px;
        border-radius: 15px;
        width: 90%;
        max-width: 600px;
        max-height: 90vh;
        overflow-y: auto;
    }
    
    .close {
        float: right;
        font-size: 28px;
        font-weight: bold;
        cursor: pointer;
    }
    </style>
</body>
</html>

