<?php
require_once '../config/config.php';

if (!isLoggedIn()) {
    redirect('../index.php');
}

$db = Database::getInstance()->getConnection();

// Get all dusun with predictions
$stmt = $db->query("SELECT d.*, des.nama_desa, 
                    COALESCE(p.tingkat_risiko, 'aman') as tingkat_risiko,
                    COALESCE(p.skor_risiko, 0) as skor_risiko
                    FROM dusun d 
                    JOIN desa des ON d.desa_id = des.id
                    LEFT JOIN prediksi_kekeringan p ON d.id = p.dusun_id AND p.tanggal_prediksi >= CURDATE()
                    ORDER BY p.skor_risiko DESC");
$dusun_list = $stmt->fetchAll();

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Peta Desa - <?php echo APP_NAME; ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
</head>
<body>
    <aside class="sidebar">
        <div class="sidebar-header">
            <h2><i class="fas fa-tint"></i> <?php echo APP_NAME; ?></h2>
        </div>
        <nav class="sidebar-nav">
            <a href="../dashboard.php" class="nav-item">
                <i class="fas fa-home"></i>
                <span>Dashboard</span>
            </a>
            <a href="../prediksi/index.php" class="nav-item">
                <i class="fas fa-chart-line"></i>
                <span>Prediksi</span>
            </a>
            <a href="index.php" class="nav-item active">
                <i class="fas fa-map-marked-alt"></i>
                <span>Peta</span>
            </a>
            <a href="../auth/logout.php" class="nav-item">
                <i class="fas fa-sign-out-alt"></i>
                <span>Logout</span>
            </a>
        </nav>
    </aside>
    
    <main class="main-content">
        <header class="content-header">
            <div class="header-left">
                <h1><i class="fas fa-map-marked-alt"></i> Peta Desa Real-Time</h1>
                <p>Monitoring kondisi desa secara real-time</p>
            </div>
        </header>

        <!-- Legend -->
        <div class="content-section">
            <div style="display: flex; gap: 20px; flex-wrap: wrap; margin-bottom: 20px;">
                <div style="display: flex; align-items: center; gap: 10px;">
                    <div style="width: 30px; height: 30px; background: #e74c3c; border-radius: 50%;"></div>
                    <span>Zona Kering</span>
                </div>
                <div style="display: flex; align-items: center; gap: 10px;">
                    <div style="width: 30px; height: 30px; background: #f39c12; border-radius: 50%;"></div>
                    <span>Zona Waspada</span>
                </div>
                <div style="display: flex; align-items: center; gap: 10px;">
                    <div style="width: 30px; height: 30px; background: #2ecc71; border-radius: 50%;"></div>
                    <span>Zona Aman</span>
                </div>
            </div>
            <div id="map" style="height: 600px;"></div>
        </div>

        <!-- List -->
        <div class="content-section">
            <h2>Daftar Dusun</h2>
            <div class="table-responsive">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>Desa</th>
                            <th>Dusun</th>
                            <th>Status</th>
                            <th>Skor</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($dusun_list as $dusun): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($dusun['nama_desa']); ?></td>
                            <td><?php echo htmlspecialchars($dusun['nama_dusun']); ?></td>
                            <td>
                                <?php if ($dusun['latitude'] && $dusun['longitude']): ?>
                                <span class="badge badge-<?php echo $dusun['tingkat_risiko'] === 'kering' ? 'danger' : ($dusun['tingkat_risiko'] === 'waspada' ? 'warning' : 'success'); ?>">
                                    <?php echo ucfirst($dusun['tingkat_risiko']); ?>
                                </span>
                                <?php else: ?>
                                <span class="badge badge-warning">Belum diatur</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo number_format($dusun['skor_risiko'], 2); ?></td>
                            <td>
                                <?php if ($dusun['latitude'] && $dusun['longitude']): ?>
                                <button class="btn btn-sm btn-primary" onclick="showOnMap(<?php echo $dusun['latitude']; ?>, <?php echo $dusun['longitude']; ?>, '<?php echo htmlspecialchars($dusun['nama_dusun']); ?>')">
                                    <i class="fas fa-map-marker-alt"></i> Tampilkan
                                </button>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </main>

    <script>
    const map = L.map('map').setView([-7.7956, 110.3695], 12);
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '© OpenStreetMap contributors'
    }).addTo(map);
    
    const markers = [];
    const dusunData = <?php echo json_encode($dusun_list); ?>;
    
    dusunData.forEach(dusun => {
        if (dusun.latitude && dusun.longitude) {
            let color = '#2ecc71'; // aman
            if (dusun.tingkat_risiko === 'kering') color = '#e74c3c';
            else if (dusun.tingkat_risiko === 'waspada') color = '#f39c12';
            
            const marker = L.circleMarker([parseFloat(dusun.latitude), parseFloat(dusun.longitude)], {
                radius: 10,
                fillColor: color,
                color: '#fff',
                weight: 2,
                opacity: 1,
                fillOpacity: 0.8
            }).addTo(map);
            
            marker.bindPopup(`
                <strong>${dusun.nama_dusun}</strong><br>
                Desa: ${dusun.nama_desa}<br>
                Status: ${dusun.tingkat_risiko.toUpperCase()}<br>
                Skor: ${parseFloat(dusun.skor_risiko).toFixed(2)}
            `);
            
            markers.push(marker);
        }
    });
    
    function showOnMap(lat, lng, name) {
        map.setView([lat, lng], 15);
        markers.forEach(m => {
            if (m.getLatLng().lat === lat && m.getLatLng().lng === lng) {
                m.openPopup();
            }
        });
    }
    </script>
    <script src="../assets/js/main.js"></script>
</body>
</html>

