<?php
require_once '../config/config.php';

if (!isAdmin()) {
    http_response_code(403);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

$db = Database::getInstance()->getConnection();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'count_target') {
    $filter_desa_id = intval($_POST['desa_id'] ?? 0);
    $filter_dusun_id = intval($_POST['dusun_id'] ?? 0);
    $filter_status = sanitize($_POST['status'] ?? '');
    
    // Build filter query
    $where = "u.role = 'warga' AND u.status = 'active' AND u.no_hp IS NOT NULL AND u.no_hp != ''";
    if ($filter_desa_id > 0) {
        $where .= " AND des.id = $filter_desa_id";
    }
    if ($filter_dusun_id > 0) {
        $where .= " AND d.id = $filter_dusun_id";
    }
    if (!empty($filter_status)) {
        $where .= " AND u.status = '$filter_status'";
    }
    
    // Count target users
    $stmt = $db->query("SELECT COUNT(*) as count
                       FROM users u 
                       LEFT JOIN dusun d ON u.dusun_id = d.id 
                       LEFT JOIN desa des ON d.desa_id = des.id 
                       WHERE $where");
    $result = $stmt->fetch();
    
    header('Content-Type: application/json');
    echo json_encode(['count' => intval($result['count'])]);
    exit;
}

http_response_code(400);
echo json_encode(['error' => 'Invalid request']);

