<?php
require_once '../config/config.php';

if (!isAdmin()) {
    redirect('../dashboard.php');
}

$db = Database::getInstance()->getConnection();

$broadcast_id = intval($_GET['id'] ?? 0);

if ($broadcast_id === 0) {
    redirect('wa_broadcast.php');
}

// Get broadcast info
$stmt = $db->prepare("SELECT b.*, u.nama_lengkap as created_by_name, des.nama_desa, d.nama_dusun
                     FROM wa_broadcast b
                     JOIN users u ON b.created_by = u.id
                     LEFT JOIN desa des ON b.filter_desa_id = des.id
                     LEFT JOIN dusun d ON b.filter_dusun_id = d.id
                     WHERE b.id = ?");
$stmt->execute([$broadcast_id]);
$broadcast = $stmt->fetch();

if (!$broadcast) {
    redirect('wa_broadcast.php');
}

// Get broadcast logs
$stmt = $db->prepare("SELECT l.*, u.nama_lengkap, u.no_hp
                     FROM wa_broadcast_log l
                     JOIN users u ON l.user_id = u.id
                     WHERE l.broadcast_id = ?
                     ORDER BY l.sent_at DESC");
$stmt->execute([$broadcast_id]);
$logs = $stmt->fetchAll();

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detail Broadcast - <?php echo APP_NAME; ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <?php include '../includes/sidebar.php'; ?>
    
    <main class="main-content">
        <header class="content-header">
            <div class="header-left">
                <h1><i class="fab fa-whatsapp"></i> Detail Broadcast</h1>
                <p>Informasi lengkap broadcast WhatsApp</p>
            </div>
            <a href="wa_broadcast.php" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </header>

        <!-- Broadcast Info -->
        <div class="content-section">
            <h2>Informasi Broadcast</h2>
            <div class="form-container" style="background: #f8f9fa; padding: 20px; border-radius: 8px;">
                <div class="form-row">
                    <div class="form-group">
                        <label><strong>Judul:</strong></label>
                        <p><?php echo htmlspecialchars($broadcast['judul']); ?></p>
                    </div>
                    <div class="form-group">
                        <label><strong>Status:</strong></label>
                        <p>
                            <span class="badge badge-<?php 
                                echo $broadcast['status'] === 'completed' ? 'success' : 
                                    ($broadcast['status'] === 'sending' ? 'warning' : 
                                    ($broadcast['status'] === 'failed' ? 'danger' : 'info')); 
                            ?>">
                                <?php echo ucfirst($broadcast['status']); ?>
                            </span>
                        </p>
                    </div>
                </div>
                <div class="form-group">
                    <label><strong>Pesan:</strong></label>
                    <p style="white-space: pre-wrap; background: white; padding: 15px; border-radius: 5px;"><?php echo htmlspecialchars($broadcast['pesan']); ?></p>
                </div>
                <?php if (!empty($broadcast['gambar'])): ?>
                <div class="form-group">
                    <label><strong>Gambar:</strong></label>
                    <img src="../<?php echo htmlspecialchars($broadcast['gambar']); ?>" alt="Broadcast Image" style="max-width: 100%; max-height: 400px; border-radius: 8px; margin-top: 10px;">
                </div>
                <?php endif; ?>
                <div class="form-row">
                    <div class="form-group">
                        <label><strong>Filter Desa:</strong></label>
                        <p><?php echo htmlspecialchars($broadcast['nama_desa'] ?? 'Semua Desa'); ?></p>
                    </div>
                    <div class="form-group">
                        <label><strong>Filter Dusun:</strong></label>
                        <p><?php echo htmlspecialchars($broadcast['nama_dusun'] ?? 'Semua Dusun'); ?></p>
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label><strong>Total Target:</strong></label>
                        <p><?php echo $broadcast['total_target']; ?> warga</p>
                    </div>
                    <div class="form-group">
                        <label><strong>Terkirim:</strong></label>
                        <p><span class="badge badge-success"><?php echo $broadcast['total_terkirim']; ?></span></p>
                    </div>
                    <div class="form-group">
                        <label><strong>Gagal:</strong></label>
                        <p><span class="badge badge-danger"><?php echo $broadcast['total_gagal']; ?></span></p>
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label><strong>Dibuat Oleh:</strong></label>
                        <p><?php echo htmlspecialchars($broadcast['created_by_name']); ?></p>
                    </div>
                    <div class="form-group">
                        <label><strong>Tanggal:</strong></label>
                        <p><?php echo formatDateTime($broadcast['created_at']); ?></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Broadcast Logs -->
        <div class="content-section">
            <h2>Log Pengiriman</h2>
            <div class="table-responsive">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Nama Warga</th>
                            <th>No. HP</th>
                            <th>Status</th>
                            <th>Pesan Error</th>
                            <th>Waktu</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($logs)): ?>
                        <tr>
                            <td colspan="6" class="text-center">Belum ada log</td>
                        </tr>
                        <?php else: ?>
                        <?php $no = 1; foreach ($logs as $log): ?>
                        <tr>
                            <td><?php echo $no++; ?></td>
                            <td><?php echo htmlspecialchars($log['nama_lengkap']); ?></td>
                            <td><?php echo htmlspecialchars($log['phone_number']); ?></td>
                            <td>
                                <span class="badge badge-<?php echo $log['status'] === 'success' ? 'success' : 'danger'; ?>">
                                    <?php echo ucfirst($log['status']); ?>
                                </span>
                            </td>
                            <td><?php echo htmlspecialchars($log['error_message'] ?? '-'); ?></td>
                            <td><?php echo formatDateTime($log['sent_at']); ?></td>
                        </tr>
                        <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </main>

    <script src="../assets/js/main.js"></script>
</body>
</html>

