<!-- resources/views/landing.blade.php -->
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SumberAI - Peringatan Dini Kekeringan & Manajemen Air Desa</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #2563eb;
            --secondary-color: #06b6d4;
            --danger-color: #dc2626;
            --warning-color: #f59e0b;
            --success-color: #10b981;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .landing-container {
            max-width: 500px;
            margin: 20px auto;
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            overflow: hidden;
        }
        
        .header-section {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            padding: 40px 30px;
            text-align: center;
            color: white;
        }
        
        .app-logo {
            width: 100px;
            height: 100px;
            background: white;
            border-radius: 50%;
            margin: 0 auto 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
        }
        
        .app-logo i {
            font-size: 50px;
            color: var(--primary-color);
        }
        
        .app-title {
            font-size: 28px;
            font-weight: bold;
            margin-bottom: 10px;
        }
        
        .app-subtitle {
            font-size: 14px;
            opacity: 0.9;
        }
        
        .content-section {
            padding: 30px;
        }
        
        .feature-list {
            list-style: none;
            padding: 0;
            margin: 20px 0;
        }
        
        .feature-list li {
            padding: 10px 0;
            border-bottom: 1px solid #e5e7eb;
            display: flex;
            align-items: center;
        }
        
        .feature-list li i {
            color: var(--primary-color);
            margin-right: 15px;
            font-size: 20px;
        }
        
        .btn-custom {
            width: 100%;
            padding: 15px;
            border-radius: 10px;
            font-weight: 600;
            border: none;
            margin-bottom: 15px;
            transition: all 0.3s;
        }
        
        .btn-login {
            background: var(--primary-color);
            color: white;
        }
        
        .btn-login:hover {
            background: #1d4ed8;
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(37, 99, 235, 0.3);
        }
        
        .btn-register {
            background: white;
            color: var(--primary-color);
            border: 2px solid var(--primary-color);
        }
        
        .btn-register:hover {
            background: var(--primary-color);
            color: white;
        }
        
        .footer-text {
            text-align: center;
            padding: 20px;
            font-size: 12px;
            color: #6b7280;
            border-top: 1px solid #e5e7eb;
        }
        
        @media (max-width: 576px) {
            .landing-container {
                margin: 10px;
                border-radius: 15px;
            }
            .app-title {
                font-size: 24px;
            }
        }
    </style>
</head>
<body>
    <div class="landing-container">
        <div class="header-section">
            <div class="app-logo">
                <i class="fas fa-tint"></i>
            </div>
            <div class="app-title">SumberAI</div>
            <div class="app-subtitle">
                Sistem Peringatan Dini Kekeringan & Manajemen Air Desa
            </div>
        </div>
        
        <div class="content-section">
            <h5 class="mb-3" style="color: #1f2937; font-weight: 600;">Fitur Unggulan:</h5>
            <ul class="feature-list">
                <li>
                    <i class="fas fa-brain"></i>
                    <span>Prediksi AI Risiko Kekeringan 7 Hari</span>
                </li>
                <li>
                    <i class="fas fa-map-marked-alt"></i>
                    <span>Peta Desa Real-Time</span>
                </li>
                <li>
                    <i class="fas fa-bell"></i>
                    <span>Notifikasi Hemat Air Otomatis</span>
                </li>
                <li>
                    <i class="fas fa-truck"></i>
                    <span>Jadwal Distribusi Tangki Air</span>
                </li>
                <li>
                    <i class="fas fa-chart-line"></i>
                    <span>Dashboard Analitik Pemdes</span>
                </li>
            </ul>
            
            <div class="mt-4">
                <a href="{{ route('login') }}" class="btn btn-login btn-custom">
                    <i class="fas fa-sign-in-alt me-2"></i> Masuk
                </a>
                <a href="{{ route('register') }}" class="btn btn-register btn-custom">
                    <i class="fas fa-user-plus me-2"></i> Daftar Akun Baru
                </a>
            </div>
        </div>
        
        <div class="footer-text">
            <i class="fas fa-copyright"></i> 2025 Skipotech Innovation<br>
            SumberAI v1.0 - Fully Locked Configuration
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
