<!-- resources/views/dashboard/index.blade.php -->
@extends('layouts.app')

@section('content')
<div class="dashboard-container">
    <!-- Header Stats -->
    <div class="stats-grid">
        <div class="stat-card red">
            <div class="stat-icon"><i class="fas fa-exclamation-triangle"></i></div>
            <div class="stat-content">
                <h3>{{ $stats['total_desa_kritis'] }}</h3>
                <p>Desa Kritis</p>
            </div>
        </div>
        <div class="stat-card yellow">
            <div class="stat-icon"><i class="fas fa-file-alt"></i></div>
            <div class="stat-content">
                <h3>{{ $stats['total_laporan'] }}</h3>
                <p>Laporan Pending</p>
            </div>
        </div>
        <div class="stat-card blue">
            <div class="stat-icon"><i class="fas fa-truck"></i></div>
            <div class="stat-content">
                <h3>{{ $stats['tangki_dijadwalkan'] }}</h3>
                <p>Tangki Dijadwalkan</p>
            </div>
        </div>
        <div class="stat-card green">
            <div class="stat-icon"><i class="fas fa-bell"></i></div>
            <div class="stat-content">
                <h3>{{ $stats['notifikasi_unread'] }}</h3>
                <p>Notifikasi Baru</p>
            </div>
        </div>
    </div>
    
    <!-- Icon Menu Grid -->
    <div class="menu-grid">
        <a href="{{ route('prediksi.index') }}" class="menu-item">
            <div class="menu-icon bg-blue">
                <i class="fas fa-brain"></i>
            </div>
            <span>Prediksi AI</span>
        </a>
        
        <a href="{{ route('peta') }}" class="menu-item">
            <div class="menu-icon bg-green">
                <i class="fas fa-map-marked-alt"></i>
            </div>
            <span>Peta Desa</span>
        </a>
        
        <a href="{{ route('laporan.index') }}" class="menu-item">
            <div class="menu-icon bg-orange">
                <i class="fas fa-file-alt"></i>
            </div>
            <span>Laporan</span>
        </a>
        
        <a href="#" class="menu-item">
            <div class="menu-icon bg-purple">
                <i class="fas fa-bell"></i>
            </div>
            <span>Notifikasi</span>
        </a>
        
        <a href="#" class="menu-item">
            <div class="menu-icon bg-red">
                <i class="fas fa-exclamation-circle"></i>
            </div>
            <span>Peringatan</span>
        </a>
        
        <a href="#" class="menu-item">
            <div class="menu-icon bg-cyan">
                <i class="fas fa-chart-line"></i>
            </div>
            <span>Statistik</span>
        </a>
        
        @if(auth()->user()->isAdmin())
        <a href="{{ route('admin.dashboard') }}" class="menu-item">
            <div class="menu-icon bg-dark">
                <i class="fas fa-cog"></i>
            </div>
            <span>Admin</span>
        </a>
        @endif
        
        <a href="#" class="menu-item">
            <div class="menu-icon bg-teal">
                <i class="fas fa-user-circle"></i>
            </div>
            <span>Profile</span>
        </a>
    </div>
    
    <!-- Prediksi 7 Hari -->
    <div class="card mt-4">
        <div class="card-header">
            <h5><i class="fas fa-calendar-week me-2"></i>Prediksi 7 Hari Ke Depan</h5>
        </div>
        <div class="card-body">
            <div class="prediksi-list">
                @foreach($prediksi as $p)
                <div class="prediksi-item risiko-{{ $p->tingkat_risiko }}">
                    <div class="prediksi-date">
                        <strong>{{ $p->tanggal_prediksi->format('d M') }}</strong>
                        <small>{{ $p->tanggal_prediksi->format('Y') }}</small>
                    </div>
                    <div class="prediksi-info">
                        <h6>{{ $p->desa->nama_desa }}</h6>
                        <p class="mb-1">
                            <i class="fas fa-cloud-rain"></i> {{ $p->curah_hujan }}mm |
                            <i class="fas fa-water"></i> {{ $p->kelembapan_tanah }}%
                        </p>
                        <span class="badge bg-{{ $p->risiko_color }}">
                            {{ strtoupper($p->tingkat_risiko) }} ({{ $p->risiko_score }})
                        </span>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</div>
@endsection

@section('styles')
<style>
    .stats-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
        gap: 15px;
        margin-bottom: 25px;
    }
    
    .stat-card {
        background: white;
        border-radius: 15px;
        padding: 20px;
        display: flex;
        align-items: center;
        box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    }
    
    .stat-icon {
        font-size: 40px;
        margin-right: 15px;
    }
    
    .stat-card.red { border-left: 5px solid #dc2626; }
    .stat-card.red .stat-icon { color: #dc2626; }
    .stat-card.yellow { border-left: 5px solid #f59e0b; }
    .stat-card.yellow .stat-icon { color: #f59e0b; }
    .stat-card.blue { border-left: 5px solid #2563eb; }
    .stat-card.blue .stat-icon { color: #2563eb; }
    .stat-card.green { border-left: 5px solid #10b981; }
    .stat-card.green .stat-icon { color: #10b981; }
    
    .menu-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(100px, 1fr));
        gap: 15px;
        margin-bottom: 25px;
    }
    
    .menu-item {
        text-align: center;
        text-decoration: none;
        color: #1f2937;
        transition: transform 0.2s;
    }
    
    .menu-item:hover {
        transform: translateY(-5px);
    }
    
    .menu-icon {
        width: 70px;
        height: 70px;
        margin: 0 auto 10px;
        border-radius: 15px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 30px;
        color: white;
        box-shadow: 0 4px 15px rgba(0,0,0,0.2);
    }
    
    .bg-blue { background: linear-gradient(135deg, #2563eb, #3b82f6); }
    .bg-green { background: linear-gradient(135deg, #10b981, #34d399); }
    .bg-orange { background: linear-gradient(135deg, #f59e0b, #fbbf24); }
    .bg-purple { background: linear-gradient(135deg, #8b5cf6, #a78bfa); }
    .bg-red { background: linear-gradient(135deg, #dc2626, #ef4444); }
    .bg-cyan { background: linear-gradient(135deg, #06b6d4, #22d3ee); }
    .bg-dark { background: linear-gradient(135deg, #1f2937, #374151); }
    .bg-teal { background: linear-gradient(135deg, #14b8a6, #2dd4bf); }
    
    .prediksi-list {
        display: flex;
        flex-direction: column;
        gap: 15px;
    }
    
    .prediksi-item {
        display: flex;
        padding: 15px;
        border-radius: 10px;
        border-left: 5px solid;
        background: #f9fafb;
    }
    
    .prediksi-item.risiko-aman { border-left-color: #10b981; }
    .prediksi-item.risiko-waspada { border-left-color: #f59e0b; }
    .prediksi-item.risiko-kritis { border-left-color: #dc2626; }
    
    .prediksi-date {
        min-width: 80px;
        text-align: center;
        border-right: 1px solid #e5e7eb;
        padding-right: 15px;
        margin-right: 15px;
    }
    
    @media (max-width: 768px) {
        .stats-grid {
            grid-template-columns: repeat(2, 1fr);
        }
        .menu-grid {
            grid-template-columns: repeat(4, 1fr);
        }
        .menu-icon {
            width: 60px;
            height: 60px;
            font-size: 24px;
        }
        .menu-item span {
            font-size: 12px;
        }
    }
</style>
@endsection
