<?php
// database/migrations/2025_01_01_000005_create_laporan_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('laporan', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('desa_id')->constrained()->onDelete('cascade');
            $table->foreignId('dusun_id')->nullable()->constrained()->onDelete('cascade');
            $table->enum('jenis_laporan', ['sumur_kering', 'mata_air_kering', 'kebutuhan_air', 'lainnya']);
            $table->text('deskripsi');
            $table->string('foto')->nullable();
            $table->decimal('latitude', 10, 7)->nullable();
            $table->decimal('longitude', 10, 7)->nullable();
            $table->enum('status', ['pending', 'ditinjau', 'selesai'])->default('pending');
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('laporan');
    }
};
